<?php
// uber_auth_test.php
require_once __DIR__ . '/uber_config.php';

$urls = [
  'Production (login)' => 'https://login.uber.com/oauth/v2/token',
  'Production (auth)' => 'https://auth.uber.com/oauth/v2/token',
  'Sandbox (auth)' => 'https://sandbox-auth.uber.com/oauth/v2/token',
  'Sandbox (login)' => 'https://sandbox-login.uber.com/oauth/v2/token', // Guess
];

echo "--- Uber Auth Diagnostic ---\n";
echo "Client ID: " . substr(UBER_CLIENT_ID, 0, 5) . "...\n";
echo "Environment: " . UBER_ENVIRONMENT . "\n\n";

foreach ($urls as $name => $url) {
  echo "Testing [$name]: $url\n";

  $postFields = http_build_query([
    'grant_type' => 'client_credentials',
    'client_id' => UBER_CLIENT_ID,
    'client_secret' => UBER_CLIENT_SECRET,
    'scope' => 'eats.store.orders.read',
  ]);

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postFields,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 5,
    CURLOPT_SSL_VERIFYPEER => false // Temporary for testing
  ]);

  $raw = curl_exec($ch);
  $err = curl_error($ch);
  $info = curl_getinfo($ch);
  curl_close($ch);

  if ($err) {
    echo "  -> Connection Failed: $err\n";
  } else {
    echo "  -> HTTP Status: " . $info['http_code'] . "\n";
    $data = json_decode($raw, true);
    if (isset($data['access_token'])) {
      echo "  -> SUCCESS! Access Token received.\n";
    } else {
      echo "  -> Error: " . ($data['error'] ?? 'Unknown') . "\n";
      if (isset($data['error_description'])) {
        echo "     Desc: " . $data['error_description'] . "\n";
      }
    }
  }
  echo "\n";
}
