<?php
// uber_config.php
// Basic configuration + logging helpers for Uber webhook integration.
//
// This file now also includes placeholders for the Tookan / Skedadel side
// so that the create + cancel webhooks can build a fully shaped payload
// and write it to logs without actually sending anything yet.

declare(strict_types=1);

// --- Uber OAuth client credentials ---
// Replace with your real Uber client credentials.
const UBER_CLIENT_ID = 'DVinryBEatELx5jfOR8LO5LfWBJL1rBf';
const UBER_CLIENT_SECRET = 'iI0Fk1uaYos-3qTtPAsWhVEpn3RioMtvMOkHffeS';
// 'production' or 'sandbox' just for your own reference/logs.
const UBER_ENVIRONMENT = 'sandbox';

// --- Downstream Skedadel / Tookan settings ---
// This is the key your own middleware (create-pick-delivery-task.php / cancel-task.php)
// or a direct Tookan call will expect. For now this is used only for logging.
const UBER_SKED_API_KEY = '536221c3f74708131e112b311314264f1ce7ccfe22de';

// Google Maps API Key for address resolution
const GOOGLE_MAPS_API_KEY = 'AIzaSyCri5TmJCL4DNjYKzSpQyHuM4KRXn_BasQ';

// ntfy.sh Notification Config
const NTFY_TOPIC = 'rdp0huLjjJnGSQb7'; // From uber.txt
const NTFY_TOKEN = 'tk_8z3vi5ribtimwpucou54r3vd6yu7l'; // From uber.txt

// If you later decide to call Tookan directly from these webhooks (instead of
// going via create-pick-delivery-task.php), fill in the fields below and you
// will already have a correctly shaped Tookan payload in the logs.
const UBER_TOOKAN_API_KEY = '536221c3f74708131e112b311314264f1ce7ccfe22de';
const UBER_TOOKAN_TEAM_ID = '1479655';     // Example: BP Meadowlands team
const UBER_TOOKAN_TIMEZONE = '-120';        // Tookan timezone offset string
const UBER_TOOKAN_TEMPLATE = 'Uber';        // Tookan custom-field template name

// Test Store UUID provided by user
const UBER_TEST_STORE_UUID = '08d61553-1779-45d7-accb-cc740e5d06e9';

// Default pickup (store) details – BP Meadowlands for now.
// You can change these later or make them dynamic if you onboard more stores.
const UBER_DEFAULT_PICKUP_NAME = 'KFC BP MEADOWLANDS';
const UBER_DEFAULT_PICKUP_PHONE = '0860 100 222';
const UBER_DEFAULT_PICKUP_ADDRESS = 'Corner Modise Street And, Mabasotho St, Meadowlands, Soweto, 1803';
const UBER_DEFAULT_PICKUP_LATITUDE = 0.0;   // Optional – can stay 0 while testing
const UBER_DEFAULT_PICKUP_LONGITUDE = 0.0;

/**
 * Simple log writer for Uber integration.
 *
 * All log entries go to logs/uber-webhooks.log in this directory.
 * Make sure the web server user has write permissions to /logs.
 */
function uberLog(string $type, array $data = []): void
{
    $dir = __DIR__ . '/logs';
    if (!is_dir($dir)) {
        @mkdir($dir, 0775, true);
    }

    $line = date('c') . "\t" . $type . "\t" . json_encode($data, JSON_UNESCAPED_UNICODE) . PHP_EOL;
    @file_put_contents($dir . '/uber-webhooks.log', $line, FILE_APPEND);
}

/**
 * Helper to send a JSON response and terminate.
 */
function uberJsonResponse(int $statusCode, array $body): void
{
    http_response_code($statusCode);
    header('Content-Type: application/json');
    echo json_encode($body);
    exit;
}
