<?php
// uber_test_order.php
require_once __DIR__ . '/uber_helpers.php';

$type = $_GET['type'] ?? '';

header('Content-Type: text/plain');

if ($type === 'upstream') {
  echo "Attempting to inject order via Uber Sandbox API...\n";

  // Injection requires 'business.receipts' scope
  $accessToken = getUberAccessToken('eats.store.orders.read business.receipts');

  if (!$accessToken) {
    echo "Error: Could not get Access Token. Check credentials in uber_config.php.\n";
    exit;
  }
  echo "Access Token retrieved.\n";

  // Endpoint for simulating a completed order
  // Using test-api.uber.com for Eats Sandbox
  $url = 'https://test-api.uber.com/v1/sandbox/terminal-state-eats-run';

  // Sample payload for injection
  $data = [
    'eater_location' => [
      'point' => [
        'latitude' => 37.7749,
        'longitude' => -122.4194
      ]
    ],
    'eater_info' => [
      'identifier' => [
        'email_address' => 'test_eater@example.com'
      ]
    ],
    'scenario' => [
      'id' => 'COMPLETED_STATE_DELIVERY_ORDER'
    ]
  ];

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer ' . $accessToken,
      'Content-Type: application/json'
    ]
  ]);

  $response = curl_exec($ch);
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $path = dirname($_SERVER['REQUEST_URI']);
  $targetUrl = "$protocol://$host$path/uber_create_webhook.php";

  echo "Target URL: $targetUrl\n";

  // Sample Webhook Payload
  // Using test-api.uber.com for the resource_href to match the helper logic
  $payload = [
    'event_type' => 'orders.notification',
    'resource_href' => 'https://test-api.uber.com/v1/eats/orders/TEST_ORDER_123',
    'meta' => [
      'resource_id' => 'TEST_ORDER_123',
      'user_id' => 'TEST_USER_456'
    ]
  ];

  $ch = curl_init($targetUrl);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json']
  ]);

  $response = curl_exec($ch);
  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $err = curl_error($ch);
  curl_close($ch);

  if ($err) {
    echo "Curl Error: $err\n";
    echo "Note: If you are running this without a web server (e.g. just opening the file), this won't work.\n";
  } else {
    echo "Response Code: $httpCode\n";
    echo "Response Body: $response\n";
    echo "\nCheck logs/uber-webhooks.log for details.\n";
  }

} else {
  echo "Invalid test type.";
}
