<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Uber Integration Test Suite</title>
  <style>
    body {
      font-family: sans-serif;
      max-width: 800px;
      margin: 2rem auto;
      padding: 0 1rem;
      line-height: 1.5;
    }

    h1 {
      border-bottom: 2px solid #333;
      padding-bottom: 0.5rem;
    }

    .card {
      border: 1px solid #ddd;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      border-radius: 8px;
      background: #f9f9f9;
    }

    .btn {
      display: inline-block;
      padding: 0.75rem 1.5rem;
      background: #000;
      color: #fff;
      text-decoration: none;
      border-radius: 4px;
      border: none;
      cursor: pointer;
      font-size: 1rem;
    }

    .btn:hover {
      background: #333;
    }

    .btn-secondary {
      background: #666;
    }

    pre {
      background: #eee;
      padding: 1rem;
      overflow-x: auto;
      border-radius: 4px;
    }

    .response-area {
      margin-top: 1rem;
      border: 1px solid #ccc;
      padding: 1rem;
      background: #fff;
      min-height: 100px;
      white-space: pre-wrap;
    }
  </style>
</head>

<body>
  <h1>Uber Integration Test Suite</h1>

  <div class="card">
    <h2>Option 1: Inject Sandbox Order (Upstream)</h2>
    <p>This attempts to call the Uber Eats Sandbox API to "inject" a test order. If successful, Uber should send a
      webhook to your <code>uber_create_webhook.php</code> endpoint.</p>
    <p><strong>Note:</strong> This requires your Uber App to have the correct scopes and be in the Sandbox environment.
    </p>
    <button class="btn" onclick="runTest('upstream')">Inject Test Order</button>
  </div>

  <div class="card">
    <h2>Option 2: Simulate Webhook (Local)</h2>
    <p>This bypasses Uber and sends a sample "Order Notification" JSON payload directly to your local
      <code>uber_create_webhook.php</code> script. Use this to verify your PHP logic (Google Maps, Tookan, etc.).</p>
    <button class="btn btn-secondary" onclick="runTest('local')">Simulate Webhook</button>
  </div>

  <h3>Test Output</h3>
  <div id="output" class="response-area">Ready...</div>

  <script>
    async function runTest(type) {
      const output = document.getElementById('output');
      output.textContent = 'Running ' + type + ' test...';

      try {
        const response = await fetch('uber_test_order.php?type=' + type);
        const text = await response.text();
        output.textContent = text;
      } catch (e) {
        output.textContent = 'Error: ' + e.message;
      }
    }
  </script>
</body>

</html>